<?php
// Database connection parameters
$servername = "localhost";
$username = "root";
$password = "";
$database = "mirror_notifications";

// Firebase Cloud Messaging Server Key
$FCM_SERVER_KEY = "AAAA4nIybgE:APA91bHmk9BeGulgnAv2mSGafrdY-7SD_KwqzgKHMai77O92e5vZwVZ6qr2bKHA-EYz9NjF05mizOD1mcKOYfwTo5SMSIfXoAZHUAJm4ugHa2QsdHDg9Eta0aVVrtgghf6fRGqM-ysbS"; // Replace with your actual FCM server key

// Create connection
$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if the data is received through POST request
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Fetching values from the POST request
    $currentUserId = $_POST['currentUserId'];
    $receiverId = $_POST['receiverId'];
    $appName = $_POST['appName'];
    $userName = $_POST['userName'];
    $message = $_POST['message'];
    $currentTime = $_POST['currentTime'];
    $fcmToken = $_POST['fcmToken'];
    $remoteInput = $_POST['remoteInput']; // Add remoteInput value

    // SQL query to insert data into the notification_content table
    $sql = "INSERT INTO `notification_content`(`currentUserId`, `receiverId`, `appName`, `userName`, `message`, `currentTime`, `fcmToken`, `remoteInput`) 
            VALUES ('$currentUserId','$receiverId','$appName','$userName','$message','$currentTime', '$fcmToken', '$remoteInput')";

    if ($conn->query($sql) === TRUE) {
        // Get the last inserted ID
        $notificationContentId = $conn->insert_id;

        // Notify success and return data
        echo json_encode(array('status' => 'success', 'notificationContentId' => $notificationContentId, 'fcmToken' => $fcmToken));

        // Send push notification with additional data
        sendPushNotification($fcmToken, $message, $FCM_SERVER_KEY, $notificationContentId, $currentUserId, $receiverId, $appName, $userName, $remoteInput);
    } else {
        // Notify error
        echo json_encode(array('status' => 'error', 'message' => $conn->error));
    }
} else {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid request method'));
}

// Close the database connection
$conn->close();

// Function to send push notification
function sendPushNotification($fcmToken, $message, $serverKey, $notificationContentId, $currentUserId, $receiverId, $appName, $userName, $remoteInput) {
    $url = 'https://fcm.googleapis.com/fcm/send';

    $headers = array(
        'Authorization: key=' . $serverKey,
        'Content-Type: application/json'
    );

    $data = array(
        'to' => $fcmToken,
        'data' => array(
            'messageType' => 'notification',
            'notificationContentId' => $notificationContentId,
            'currentUserId' => $currentUserId,
            'receiverId' => $receiverId,
            'appName' => $appName,
            'userName' => $userName,
            'message' => $message,
            'fcmToken' => $fcmToken,
            'remoteInput' => $remoteInput, // Include remoteInput in the data payload
            'title' => 'Notification Title',
            'sound' => 'default',
            'click_action' => 'FCM_PLUGIN_ACTIVITY'
        )
    );

    $options = array(
        'http' => array(
            'header'  => implode("\r\n", $headers),
            'method'  => 'POST',
            'content' => json_encode($data)
        )
    );

    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);

    if ($result === FALSE) {
        echo json_encode(array('status' => 'error', 'message' => 'Error sending FCM notification'));
    } else {
        echo json_encode(array('status' => 'success', 'message' => 'FCM notification sent successfully'));
    }
}
?>
